/*
   UNSAFE for DOS
   Version 1.0 (beta 4)
   Copyright (C) Jodeart Mindworks 1997, 1998, 1999, 2000 2001 2002
*/

void hlp_displayf(long);
void cutscr(void);
void newline(void);
boolean statusbar(word32);
void barscr(void);
void cursor(byte);
byte getstr(byte *,unsigned byte);
boolean abort_menu(void);
void overwrite_menu(byte *filename);
void enter_password(byte *password,boolean encrypt);
void abort_screen();
void display_percent(word32 i);
void errmsg(byte *,int);

void statusbar_init()
{
 int i;
 barPOS=0;
 barCHAR=1;
 PERCENT=0L;
 oldPORCENTAJETOTAL=0L;
 gotoxy(12,11);
 cprintf("   ");
 for(i=1;i<51;i++)
 {
  gotoxy(16+i,11);
  cprintf(" ");
 }
}

/******************************************************************************
* procedure : statusbar(), display % bar on screen                            *
* in : filelength                                                             *
******************************************************************************/
boolean statusbar(word32 i)
{
 word32 TOTAL=0L,PORCENTAJETOTAL=0L,AVANCE=0L;
 boolean retorna=TRUE;

 retorna=abort_menu(); /* if esc is pressed, display menu for abort */
 gotoxy(12,11);
 TOTAL=(i/_lS_);
 if(i%_lS_!=0)TOTAL++;
 PERCENT++;
 PORCENTAJETOTAL=(PERCENT*100)/TOTAL;
 if(PORCENTAJETOTAL>100)PORCENTAJETOTAL=100;
 if(oldPORCENTAJETOTAL!=PORCENTAJETOTAL)
 {
  if(PORCENTAJETOTAL<10)gotoxy(14,11);
  else if(PORCENTAJETOTAL<100)gotoxy(13,11);
       else gotoxy(12,11);
  cprintf("%d",PORCENTAJETOTAL);
  AVANCE=PORCENTAJETOTAL-oldPORCENTAJETOTAL;
  retorna=abort_menu();
  while(AVANCE!=0)
  {
   retorna=abort_menu();
   gotoxy(17+barPOS,11);
   if(barCHAR==1)
   {
    cprintf("");
    barCHAR=2;
   }
   else
   {
    cprintf("");
    barCHAR=1;
    barPOS++;
   }
   AVANCE--;
  }
 }
 oldPORCENTAJETOTAL=PORCENTAJETOTAL;
 return(retorna);
}

void cutscr(void)
{
 int a=0,b=0;
 unsigned char tacha[]={' ',0x07};

 for(a=1;a<=25;a++)for(b=0;b<=80;b++)
 {
  b+=2;
  if(!(b==80&&a==25))
  {
   if(b==80)
   {
    gotoxy(b,a);
    printf(" ");
   }
   else
   {
    gotoxy(b,a);
    printf("  ");
   }
  }
  else puttext(80,25,80,25,tacha);
 }
 for(b=1;b<=80;b++)for(a=1;a<=24;a++){a++;gotoxy(b,a);printf(" ");}
 for(a=1;a<=25;a++)for(b=1;b<=80;b++)
 {
  if(!(b==80&&a==25))
  {
   gotoxy(b,a);
   printf(" ");
  }
  else {puttext(80,25,80,25,tacha);}
  b+=2;
 }
 clrscr();
}

void hlp_displayf(long total)
{
 #define BARLEN 24L
 long percent;
 int button,_xpos,_ypos;
 int i;

 if(_USE_MOUSE_==ON)
 {
  getmouse(&button,&_xpos,&_ypos);
  if(button==_BUTTON_TO_USE_)return;
 }
 percent=(total*100L)/HLPSIZE;
 gotoxy(56,1);
 if(percent!=100)
 {
  for(i=0;i<(int)((percent*BARLEN)/100L);i++)cprintf("");
  for(;i<BARLEN;i++)cprintf("");
 }
 else
 {
  gotoxy(56,1);
  for(i=0;i<BARLEN;i++)cprintf("");
 }
}

/******************************************************************************
* procedure : getstr, get string in hidden mode                               *
* in : target string, string lenght                                           *
* out: last pressed key (13 = ENTER, 27 = ESC, etc.)                          *
******************************************************************************/
byte getstr(byte *string,unsigned byte len)
{
 byte auxstr[MAXSIZE];
 byte insmode=0;
 byte value,pos=1,noquit=1;
 byte i;

 for(i=0;i<MAXSIZE;i++)auxstr[i]=0;
 do
 {
  value=getch();
  switch(value)
  {
   case 13:
    {
     noquit=0;
     break;
    }
   case 27:
    {
     noquit=0;
     break;
    }
   case  9:
    {
     noquit=0;
     break;
    }
   case  8:
    {
     if(pos!=1)
      {
       pos--;
       for(i=pos;i<=(MAXSIZE-2);i++)auxstr[i]=auxstr[i+1];
       auxstr[83]=0;
      }
     break;
    }
   case  0:
    {
     value=getch();
     switch(value)
      {
       case 'K':
        {
         if((pos)!=1)pos--;
         break;
        }
       case 'M':
        {
         if(auxstr[pos]!=0&&pos!=len)pos++;
         break;
        }
       case 'G':
        {
         pos=1;
         break;
        }
       case 'O':
        {
         while(auxstr[pos]!=0)pos++;
         if(pos>len)pos=len;
         break;
        }
       case 'S':
        {
         for(i=pos;i<=(MAXSIZE-3);i++)auxstr[i]=auxstr[i+1];
         break;
        }
       case 'R':
        {
         insmode=!insmode;
         break;
        }
       default :
        {
         noquit=0;
         break;
        }
      }
     break;
    }
   default:
    {
     if(insmode)
      {
       for(i=(MAXSIZE-1);i>pos;i--)auxstr[i]=auxstr[i-1];
       auxstr[84]=0;
       auxstr[len+1]=0;
      }
     auxstr[pos]=value;
     if(pos<(len))pos++;
     break;
    }
  }
 }while(noquit);
 for(i=1;auxstr[i]!=0;i++,string++)*string=auxstr[i];
 *string=0;
 for(i=0;i<MAXSIZE;i++)auxstr[i]=0;
 return(value);
}

/******************************************************************************
* procedure : cursor, changes the cursor size                                 *
* in : cursor size                                                            *
* out: cursor size!                                                           *
******************************************************************************/
void cursor(byte _size)
{
 union REGS r;
 r.h.ah=1;
 switch(_size)
 {
   case OFF:
    {
     r.h.ch=1111;
     r.h.cl=1111;
     break;
    }
   case ON :
    {
     r.h.ch=3;
     r.h.cl=4;
     break;
    }
 }
 int86(0x10,&r,&r);
}

void overwrite_menu(byte *filename)
{
 int posi=0;
 int i=0;
 char *screen;
 char x,y;
 char ok_scr=1;

 screen=malloc(4000);
 if(screen==NULL)
 {
  ok_scr=0;
  clrscr();
 }
 else
 {
  x=wherex();
  y=wherey();
  gettext(1,1,80,25,screen);
 }
 puttext(11,9,70,13,OVERWRIT);
 textbackground(4);
 textcolor(15);
 gotoxy(24,10); cprintf("%s exist, overwrite?",filename);
 textbackground(0);
 textcolor(7);
 cursor(ON);
 do
 {
  if(posi==0)gotoxy(35,12);
  else gotoxy(44,12);
  i=getch();
  if(i==0){i=getch();i=0;}

  if(i!=13)
  {
   if(posi==0)posi=1;
   else posi=0;
  }
 }while(i!=13);
 cursor(OFF);
 if(ok_scr)
 {
  gotoxy(x,y);
  puttext(1,1,80,25,screen);
  free(screen);
 }
 if(posi==1)errmsg("program canceled",200);
}

void enter_password(byte *password,boolean encrypt)
{
 char *screen;
 char x,y;
 char ok_scr=1;
 byte getstr_ret;
 byte password2[MAXSIZE];

 burn(password2);
 screen=malloc(4000);
 if(screen==NULL)
 {
  ok_scr=0;
  clrscr();
 }
 else
 {
  x=wherex();
  y=wherey();
  gettext(1,1,80,25,screen);
 }
 textbackground(3);
 textcolor(15);
 puttext(11,9,70,11,PASSWORDSCR);
 cursor(ON);
 gotoxy(14,10); cprintf("PASSWORD : ");
 getstr_ret=getstr(password,68);
 if(getstr_ret!=13)errmsg("program canceled",201);
 if(*password==0)errmsg("not exist pw",202);
 if(encrypt)
 {
  gotoxy(14,10); cprintf("ENTER AGAIN : ");
  getstr_ret=getstr(password2,68);
  if(getstr_ret!=13)errmsg("program canceled",203);
  if(strcmp(password,password2))errmsg("pw mismatch",204);
 }
 cursor(OFF);
 textbackground(0);
 textcolor(7);
 burn(password2);
 if(ok_scr)
 {
  gotoxy(x,y);
  puttext(1,1,80,25,screen);
  free(screen);
 }
}

boolean abort_menu(void)
{
 byte keypressed;
 boolean retorna=TRUE;

 if(kbhit()!=0)
 {
  keypressed=getch();
  if(keypressed==0)keypressed=getch();
  else if(keypressed==27)retorna=FALSE;
 }
 return(retorna);
}

void display_percent(word32 i)
{
 if(statusbar(i)==FALSE)abort_screen();
}

void abort_screen()
{
 int posi=0;
 int i=0;
 char *screen;
 char x,y;
 char ok_scr=1;

 screen=malloc(4000);
 if(screen==NULL)
 {
  ok_scr=0;
  clrscr();
 }
 else
 {
  x=wherex();
  y=wherey();
  gettext(1,1,80,25,screen);
 }
 puttext(11,9,70,13,ABORT);
 textbackground(4);
 textcolor(15);
 gotoxy(22,10); cprintf("abort this operation?");
 textbackground(0);
 textcolor(7);
 cursor(ON);
 do
 {
  if(posi==0)gotoxy(35,12);
  else gotoxy(45,12);
  i=getch();
  if(i==0){i=getch();i=0;}
  if(i!=13)
  {
   if(posi==0)posi=1;
   else posi=0;
  }
 }while(i!=13);
 cursor(OFF);
 if(ok_scr)
 {
  gotoxy(x,y);
  puttext(1,1,80,25,screen);
  free(screen);
 }
 if(posi==0)errmsg("program canceled",205);
}

/******************************************************************************
* procedure : errmsg, display error message                                   *
* in : error description, error numba                                         *
* out: exit with errorlevel = error numba, but if 0 return to process         *
******************************************************************************/
void errmsg(byte *err_str,int err_num)
{
 char *screen;
 char x,y;
 char ok_scr=1;

 screen=malloc(4000);
 if(screen==NULL)
 {
  ok_scr=0;
  clrscr();
 }
 else
 {
  x=wherex();
  y=wherey();
  gettext(1,1,80,25,screen);
 }
 puttext(11,9,70,13,ERROR);
 gotoxy(22,10);
 textbackground(4);
 textcolor(15);
 cprintf("%s",err_str);
 textbackground(0);
 textcolor(7);
 cursor(ON);
 gotoxy(39,12);
 getch();
 if(ok_scr)
 {
  gotoxy(x,y);
  puttext(1,1,80,25,screen);
  free(screen);
 }

 puttext(1,1,80,17,FINISHERROR);

 if(err_num>0)
 {
  cursor(ON);
  exit(err_num);
 }
}
