/*
   UNSAFE for DOS
   Version 1.0 (beta 4)
   Copyright (C) Jodeart Mindworks 1997, 1998, 1999, 2000 2001 2002
------------------------------------------------------------------------------
    NOTES: * to compile like the original version you need TurboC 2.01,this
             version is freely available in the borland site:
                                 http://community.borland.com/museum/
           * in the program compilation, Turbo C display some warnings, but
             there are just this :p
           * source code is not fully commented, i so sorry
           * comments of cipher algorithms may be found in the original
             sources, so take a view on the "base" directory
*/

#include "stdio.h"
#include "math.h"
#include "string.h"
#include "io.h"
#include "alloc.h"
#include "fcntl.h"
#include "stdlib.h"
#include "mem.h"
#include "dos.h"
#include "process.h"

/*
 Here comes complementary UNSAFE libraries, this are the following :

                common.h     external header and #defines
                screens.h    nice binary screens
                jodeart.c    extra functions
                interfaz.c   beauty screens matrixs

 No one of this change the real encryption, are just details that i
 like to include.
*/

#include "common.h"
#include "screens.h"
#include "jodeart.c"
#include "interfaz.c"

/*
  Here comes the encryption algorithms blowfish, idea, safer and qcypher
  and the hash function Message Digest 5
  All these files was modified by me and has'nt any descriptions but you
  can see the original source code as is in the respective directory.
  Note that the copyrights and licensed varies in this algorithms, so be
  carrefull..
*/

#include "blowfish.c"
#include "md5.c"
#include "idea.c"
#include "safer.c"
#include "qcypher.c"

/*
  Here i defines UNSAFE encryption structures, cipherfiles are like this

            | filepos  |  data
            |----------|----------------------------------|
            |   1..30  |  unsafe_version_info             |
            |----------|----------------------------------|
            |  31..46  |  plaintext_hash                  |
            |----------|----------------------------------|
            |  47..59  |  original_file_name              |
            |----------|----------------------------------|
            |  60      |  original_file_attributes        |
            |----------|----------------------------------|
            |  61..64  |  original_file_date              |
            |----------|----------------------------------|
            |  65      |  unused                          |
            |----------|----------------------------------|
            |  66..    |  ciphertext                      |
            -----------------------------------------------
            NOTE : always the ciphertext filesize is multiple of 8,
                   if it hasnt, UNSAFE complete with trash

  But the most importan structure is the "KEY" structure

            | varpos   |  data
            |----------|----------------------------------|
            |   1..    |  blowfish_key                    |
            |----------|----------------------------------|
            |          |  idea_encryption_key             |
            |----------|----------------------------------|
            |          |  idea_decryption key             |
            |----------|----------------------------------|
            |          |  safer_key                       |
            -----------------------------------------------

 ups.. i'havent got calculator...
*/

#include "struct.h"

/*
  Definitions of the UNSAFE functions, there are no descriptions here but dont
  worry! additional info is in the correspondent procedure part
*/

void    UNSAFE_initkey(UNSAFE_KEY *,byte *);
void    UNSAFE_destroykey(UNSAFE_KEY *);
void    UNSAFE_xor(byte *,byte *,byte *,word16);
void    UNSAFE_equal(byte *d1,byte *d2);
boolean UNSAFE_encryptfile(word16,word16,byte *,UNSAFE_KEY);
boolean UNSAFE_decryptfile(word16,word16,byte *,UNSAFE_KEY,word16);
boolean UNSAFE_savefilehash(UNSAFE_HEADER *,word16);
boolean UNSAFE_checkfilehash(UNSAFE_HEADER *,byte *);
boolean UNSAFE_analizewipe(byte *,byte *,word16 *);
void    UNSAFE_parm2value(byte *,byte *);
void    UNSAFE_destroyparm(byte *);
void    UNSAFE_wipeerror(byte *,word16);
word16  UNSAFE_wipe(byte *,word16);
void    UNSAFE_keygen(byte *,word32);
void    UNSAFE_hlp(byte *);

#define NOT_DEFINED 128
#define ENC_NOR     1
#define ENC_FST     2 /* NOT USED! */

UNSAFE_KEY key;                    /* the most important var,its the key and */
                                   /* is burned before call errmsg()         */
byte       ciphertextfile[MAXSIZE];/*                                        */
byte       plaintextfile[MAXSIZE]; /* ALL these vars will be burned when the */
byte       password[MAXSIZE];      /* UNSAFE_destroykey() is called          */
byte       filename[MAXSIZE];      /*                                        */


main(word16 argc,byte *argv[])
{
 int           source,target;
 UNSAFE_HEADER header;
 byte          targetfile[MAXSIZE],sourcefile[MAXSIZE],
               f_dir[MAXSIZE],f_name[10],f_ext[5],f_unit[3];
 boolean       wipe,overwrite,askforpass,ispassword,encrypt;
 boolean       canexit=FALSE;
 word16 i;
 word16 wipepasses=0;
 word32 knkbytes=0;
 byte   oldscr[4000];

 cprintf("Unsafe Cryptosystem 1.0.beta4 (c) Jodeart Mindworks. Use -? for help.\n\r");

 /* initialize vars */
 encrypt=NOT_DEFINED;
 wipe=FALSE;
 overwrite=FALSE;
 askforpass=FALSE;
 ispassword=FALSE;

 UNSAFE_destroykey(&key); /* used to initialize some public vars */
 header.encryptmode=ENC_NOR; /* just this mode is available in this version */

 if(argc<2)return(99); /* if no enought parameters, quit */
 statusbar_init();
 strcpy(targetfile,TMPFILE); /* assign temp. interchange file */
 if(access(targetfile,0)==0)UNSAFE_wipe(targetfile,0);

 gettext(1,1,80,25,oldscr); /*save the start screen*/
 puttext(1,1,80,17,SCREEN);
 cursor(OFF);

 for(i=1;i<argc;i++) /* read all the parameters */
  {
   if(argv[i][0]!='-'){UNSAFE_destroykey(&key);errmsg("unknow parameter(s)",2);}
   else
   switch(tolower(argv[i][1]))
   {
    case '?':
    {
     UNSAFE_hlp(argv[0]);
     puttext(1,1,80,25,oldscr);
     return(99);
    }
    case 'm':
    {
     byte auxstr[MAXSIZE],kfilename[MAXSIZE],auxkbytes[MAXSIZE];
     size_t ii=0,j=0;

     UNSAFE_parm2value(auxstr,argv[i]);
     UNSAFE_destroyparm(argv[i]);
     while((ii<=strlen(auxstr))&&(auxstr[ii]!=','))
     {
      kfilename[ii]=auxstr[ii];
      ii++;
     }
     kfilename[ii]=0;
     if((ii-1)==strlen(auxstr))
                     {UNSAFE_destroykey(&key);errmsg("not key size defined",3);}
     else
     {
      ii++;
      while(ii<=strlen(auxstr))
      {
       auxkbytes[j]=auxstr[ii];
       ii++;
       j++;
      }
      if((knkbytes=atol(auxkbytes))==0)
                        {UNSAFE_destroykey(&key);errmsg("bad key file size",4);}
      canexit=TRUE;
     }

     gotoxy(12,13);
     cprintf("making file key %s                          ",kfilename);
     gotoxy(12,14);
     cprintf("%s                                          ",plaintextfile);
     gotoxy(12,15);
     cprintf("%s                                          ",ciphertextfile);

     if(access(kfilename,0)==0)
     {
      if(overwrite)UNSAFE_wipe(kfilename,0);
      else {
        overwrite_menu(filename);
        UNSAFE_wipe(kfilename,0);
      }
     }
     UNSAFE_keygen(kfilename,knkbytes);
     break;
    }
    case 'd':
    {
     if(argv[i][2]==0)encrypt=FALSE;
     else {UNSAFE_destroykey(&key);errmsg("bad use of decrypt option",5);}
     break;
    }
    case 'e':
    {
     if(argv[i][2]==0)encrypt=TRUE;
     else {UNSAFE_destroykey(&key);errmsg("bad use of encrypt option",6);}
     break;
    }
    case 'o':
    {
     if(argv[i][2]==0)overwrite=!overwrite;
     else {UNSAFE_destroykey(&key);errmsg("bad use of overwrite option",7);}
     break;
    }
    case 'w':
    {
     byte auxstr[MAXSIZE];

     UNSAFE_parm2value(auxstr,argv[i]);
     UNSAFE_destroyparm(argv[i]);
     if(UNSAFE_analizewipe(auxstr,&wipe,&wipepasses))
      {UNSAFE_destroykey(&key);errmsg("bad use of wipe option",8);}
     canexit=TRUE;
     break;
    }
    case 'a':
    {
     if(argv[i][2]==0)
     {
      if(!ispassword)
      {
       askforpass=!askforpass;
       ispassword=!ispassword;
      }
      else {UNSAFE_destroykey(&key);errmsg("password already exist",9);}
     }
     else {UNSAFE_destroykey(&key);errmsg("bad use of 'ask' option",10);}
     break;
    }
    case 'f': /* fast encryption mode! - DISABLED ON THIS VERSION */
    {
     header.encryptmode=ENC_FST;
    }
    case 's':
    {
     if(!ispassword)
     {
      UNSAFE_parm2value(password,argv[i]);
      UNSAFE_destroyparm(argv[i]);
     }
     else {UNSAFE_destroykey(&key);errmsg("password aldeady exist",11);}
     break;
    }
    case 'k':
    {
     /* in next version here call some real keygenerator procedure */
     void *buffer;
     word16 bytesread;
     boolean error=FALSE;
     int file;
     word32 j=0;
     MD5_INFO md5Info;
     byte keyfilename[MAXSIZE];

     if(!ispassword)
     {
      UNSAFE_parm2value(keyfilename,argv[i]);
      UNSAFE_destroyparm(argv[i]);

      gotoxy(12,13);
      cprintf("generating password from passphrase         ");
      gotoxy(12,14);
      cprintf("%s                                          ",plaintextfile);
      gotoxy(12,15);
      cprintf("%s                                          ",ciphertextfile);

      if(access(keyfilename,0)!=0)
                      {UNSAFE_destroykey(&key);errmsg("key file not found",12);}
      if((file=open(keyfilename,O_RDONLY+O_BINARY))==-1)error=TRUE;
      else
      {
       j=filelength(file);
       md5Initial(&md5Info);
       statusbar_init();
       if((buffer=malloc(_uS_))==NULL)error=TRUE;
       else
       {
        bytesread=read(file,buffer,_uS_);
        md5Update(&md5Info,buffer,bytesread);
        while(bytesread==_uS_)
        {
         bytesread=read(file,buffer,_uS_);
         md5Update(&md5Info,buffer,bytesread);
         display_percent(j);
        }
        statusbar_init();
        md5Final(&md5Info);
        free(buffer);
       }
       close(file);
      }
      if(error)
           {UNSAFE_destroykey(&key);errmsg("can't alloc, operation failed",13);}
      else
      {
       /* MD5 xor SHA be more cool.. may be in beta5 :) */
       memcpy(password,md5Info.digest,16);
      }
     }
     else {UNSAFE_destroykey(&key);errmsg("password already exist",14);}
     break;
    }
    case 'p':
    {
     UNSAFE_parm2value(plaintextfile,argv[i]);
     UNSAFE_destroyparm(argv[i]);
     break;
    }
    case 'c':
    {
     UNSAFE_parm2value(ciphertextfile,argv[i]);
     UNSAFE_destroyparm(argv[i]);
     break;
    }
    default :{UNSAFE_destroykey(&key);errmsg("parameter unknow",15);}
   }
  }
 if(*password==0)askforpass=1;
 if((encrypt==NOT_DEFINED||encrypt==TRUE)&&(*plaintextfile!=0
                                                          &&*ciphertextfile==0))
 {
  memcpy(ciphertextfile,plaintextfile,MAXSIZE);
  encrypt=TRUE;
 }
 if((encrypt==NOT_DEFINED||encrypt==FALSE)&&(*plaintextfile==0
                                                          &&*ciphertextfile!=0))
 {
  encrypt=FALSE;
 }

 if((canexit==TRUE) && (*ciphertextfile==0)){
  puttext(1,1,80,17,FINISH);
  exit(0);
 }

 if(*ciphertextfile==0)
              {UNSAFE_destroykey(&key);errmsg("no ciphertext file defined",16);}
 if(encrypt&&*plaintextfile==0)
               {UNSAFE_destroykey(&key);errmsg("no plaintext file defined",17);}
 if(encrypt)
 {
  if((source=open(plaintextfile,O_RDONLY+O_BINARY))==-1)
                     {UNSAFE_destroykey(&key);errmsg("cant open plaintext",18);}
  strcpy(filename,ciphertextfile);
 }
 else
 {
  if((source=open(ciphertextfile,O_RDONLY+O_BINARY))==-1)
                    {UNSAFE_destroykey(&key);errmsg("cant open ciphertext",19);}
  if(read(source,&header,sizeof(UNSAFE_HEADER))==-1)
                    {UNSAFE_destroykey(&key);errmsg("cant read the source",20);}
  if(strncmp(USHEAD,header.version,sizeof(header.version)))
                      {UNSAFE_destroykey(&key);errmsg("unknow file format",21);}
  else
  {
   if(*plaintextfile==0)
   {
    strcpy(filename,header.fname);
    strcpy(plaintextfile,filename);
   }
   else strcpy(filename,plaintextfile);
  }
 }
 if(askforpass)enter_password(password,encrypt);
 if(!access(filename,0))if(!overwrite)overwrite_menu(filename);

 gotoxy(12,14);
 cprintf("%s                                          ",plaintextfile);
 gotoxy(12,15);
 cprintf("%s                                          ",ciphertextfile);

 if((target=open(targetfile,O_CREAT+O_WRONLY+O_BINARY))==-1)
                   {UNSAFE_destroykey(&key);errmsg("cant open target file",22);}
 UNSAFE_initkey(&key,password);
 if(encrypt)
 {
  if(UNSAFE_savefilehash(&header,source))
                       {UNSAFE_destroykey(&key);errmsg("cant make hashing",23);}
  strncpy(header.version,USHEAD,sizeof(header.version));
  burn(header.fname);
  fnsplit(plaintextfile,f_unit,f_dir,f_name,f_ext);
  strcpy(header.fname,f_name);
  strcat(header.fname,f_ext);
  header.fattrib=(byte)_chmod(plaintextfile,0);
  getftime(source,&header.fdate);

  if((write(target,&header,sizeof(header)))==-1)
               {UNSAFE_destroykey(&key);errmsg("cant write on target file",24);}

  gotoxy(12,13);
  cprintf("encrypting...                          ");

  if(UNSAFE_encryptfile(source,target,ciphertextfile,key))
                            {UNSAFE_destroykey(&key);errmsg("cant encrypt",25);}

  close(target);
 }
 else
 {

  gotoxy(12,13);
  cprintf("decrypting...                          ");

  if(UNSAFE_decryptfile(source,target,plaintextfile,key,sizeof(UNSAFE_HEADER)))
                            {UNSAFE_destroykey(&key);errmsg("cant decrypt",26);}
  setftime(target,&header.fdate);
  close(target);
  if(UNSAFE_checkfilehash(&header,targetfile))
  {
   close(source);
   UNSAFE_destroykey(&key);
   if(wipe)
   {
    if(encrypt)UNSAFE_wipe(plaintextfile,wipepasses);
    else UNSAFE_wipe(ciphertextfile,wipepasses);
   }
   if(access(filename,0)==0) {UNSAFE_wipe(filename,0);
     clrscr();
     cprintf("%d",wipepasses);
     getch();
    }
   rename(targetfile,filename);
   UNSAFE_destroykey(&key);
   errmsg("integrity check error",27);
  }
 }
 close(source);

 if(wipe)
 {
  if(encrypt)UNSAFE_wipe(plaintextfile,wipepasses);
  else UNSAFE_wipe(ciphertextfile,wipepasses);
 }

 if(access(filename,0)==0)UNSAFE_wipe(filename,0);
 rename(targetfile,filename);
 UNSAFE_destroykey(&key);
 cursor(ON);
 puttext(1,1,80,17,FINISH);
 return(0);
}

/*******************************************************************************
* procedure : UNSAFE_initkey(), make the general key to encrypt/decrypt        *
* in : the key to create and password                                          *
* out : the password is destroyed, if not error FALSE is returned and make the *
*       key, else return TRUE                                                  *
*******************************************************************************/
void UNSAFE_initkey(UNSAFE_KEY *key,byte *password)
{
 burn((*key).bfkey);
 burn((*key).ek);
 burn((*key).dk);
 burn((*key).sfkey);
 saferExpandKey((*key).sfkey,password,SAFER_MAX_ROUNDS);
 blowfishKeyInit(&((*key).bfkey),password,MAXSIZE);
 ideaExpandKey(password,(*key).ek);
 ideaInvertKey((*key).ek,(*key).dk);
 qsetkey(password,16);
}

/*******************************************************************************
* procedure : UNSAFE_initiv(), internal key initialization                     *
* in : key and iv                                                              *
* out : initializes UNSAFE_KEY structure and IV                                *
*******************************************************************************/
void UNSAFE_initiv(UNSAFE_KEY key,byte *iv)
{
 word16 i;
 word16 j; /* number for rounds */

 for(i=0;i<BLOCKSIZE;i++)iv[i]='\0';
 for(j=0;j<512;j++)
 {
  saferDecryptBlock(iv,key.sfkey);
  ideaCipher(iv,iv,key.ek);
  blowfishEncrypt(&(key.bfkey),iv);
 }
}

/*******************************************************************************
* procedure : UNSAFE_destroykey(), destroy the unsafe key and some public vars *
* in : the key to destroy                                                      *
* out : the key is destroyed and  the public vars : password, ciphertextfile,  *
*       plaintextfile and filename                                             *
*******************************************************************************/
void UNSAFE_destroykey(UNSAFE_KEY *key)
{
 burn((*key).bfkey);
 burn((*key).ek);
 burn((*key).dk);
 burn((*key).sfkey);
 burn(password);       /*                        */
 burn(ciphertextfile); /* Aditional vars to burn */
 burn(plaintextfile);  /*                        */
 burn(filename);       /*                        */
}

/*******************************************************************************
* procedure : UNSAFE_xor(), xor two vars in another                            *
* in : two buffers and the target buffer and the size of all strings (must be  *
*      equals                                                                  *
* out : xor between two buffers                                                *
* note : in the next version, this xor will encrypt too, using some reversible *
*        algorithm                                                             *
*******************************************************************************/
void UNSAFE_xor(byte *d1,byte *d2,byte *target,word16 len)
{
 word16 i;
 for(i=0;i<len;i++)target[i]=(d1[i]^d2[i]);
}

/*******************************************************************************
* procedure : UNSAFE_equal(), just a MEMCPY                                    *
* in : two buffers of 64 bits                                                  *
* out : copy to the first buffer the second                                    *
* note : in next version this copy will be more complex to increase security   *
*******************************************************************************/
void UNSAFE_equal(byte *d1,byte *d2)
{
 memcpy(d1,d2,8);
}

/*******************************************************************************
* procedure : UNSAFE_encryptfile(), encrypt files                              *
* in : pointer to file, target file and the key                                *
* out : the file is encrypted and return TRUE if any error happend, else only  *
*       FALSE is returned                                                      *
*******************************************************************************/
boolean UNSAFE_encryptfile(word16 source,word16 target,byte *targetfilename,
                                                                 UNSAFE_KEY key)
{
 word16 count,bytes;
 int bytesread;
 word16 j;
 register byte *pbuffer;
 void *ppbuffer;
 boolean salir=FALSE;
 byte iv[BLOCKSIZE];
 word32 i;
 boolean error=FALSE;

 statusbar_init();
 UNSAFE_initiv(key,iv);
 if((i=filelength(source))==0)
 {
  close(target);
  UNSAFE_wipe(targetfilename,0);
  error=TRUE;
 }
 else
 {
  if((pbuffer=malloc(_uS_))==NULL)error=TRUE;
  else
  {
   ppbuffer=pbuffer;
   while(!salir)
   {
    if((bytesread=read(source,pbuffer,_uS_))==-1)
    {
     error=TRUE;
     salir=TRUE;
    }
    else
    {
     if(bytesread==0)salir=TRUE;
     bytes=bytesread;
     while(bytes)
      {
       if(bytes>=BLOCKSIZE)count=BLOCKSIZE;
       else
       {
        count=bytes;
        bytesread+=BLOCKSIZE;
       }
       ideaCipher(pbuffer,pbuffer,key.ek);
       UNSAFE_xor(pbuffer,iv,pbuffer,BLOCKSIZE);
       blowfishEncrypt(&(key.bfkey),pbuffer);
       saferEncryptBlock(iv,key.sfkey);
       for(j=0;j<BLOCKSIZE;j++)pbuffer[j]^=qcypher(iv[j]);
       UNSAFE_xor(iv,pbuffer,iv,BLOCKSIZE);
       bytes-=count;
       pbuffer+=BLOCKSIZE;
      }
      pbuffer=ppbuffer;
      if(write(target,pbuffer,bytesread)==-1)
               {UNSAFE_destroykey(&key);errmsg("cant write on target file",28);}
      display_percent(i);
    }
   }
   memset(pbuffer,0,_uS_);
   free(pbuffer);
  }
 }
 return(error);
}

/*******************************************************************************
* procedure : UNSAFE_decryptfile(), decrypt files                              *
* in : pointer to file, target file, the unsafe key, and the header size (the  *
*      struct with encryption info)                                            *
* out : the file is decrypted and return TRUE if any error happend, else only  *
*       FALSE is returned                                                      *
*******************************************************************************/
boolean UNSAFE_decryptfile(word16 source,word16 target,byte *targetfilename,
                                               UNSAFE_KEY key,word16 headersize)
{
 word16 count,bytes;
 int bytesread;
 word16 j;
 register byte *pbuffer;
 void *ppbuffer;
 boolean salir=FALSE;
 boolean error=FALSE;
 word32 i,aux;
 byte iv[BLOCKSIZE];
 byte ivtmp[BLOCKSIZE];
 byte ivnext[BLOCKSIZE];

 statusbar_init();
 burn(ivnext);
 UNSAFE_initiv(key,iv);
 if((i=filelength(source))<(headersize+1))
 {
  close(target);
  UNSAFE_wipe(targetfilename,0);
  error=TRUE;
 }
 else
 {
  aux=headersize; /* cast */
  i=i-aux;
  if((pbuffer=malloc(_uS_))==NULL)
                           {UNSAFE_destroykey(&key);errmsg("out of memory",29);}
  ppbuffer=pbuffer;
  while(!salir)
  {
   if((bytesread=read(source,pbuffer,_uS_))==-1)
                   {UNSAFE_destroykey(&key);errmsg("cant read source file",30);}
   if(bytesread==0)salir=TRUE;
   bytes=bytesread;
   while(bytes)
   {
    if(bytes>=BLOCKSIZE)count=BLOCKSIZE;
    else
    {
     count=bytes;
     bytesread-=BLOCKSIZE;
    }
    memcpy(ivnext,pbuffer,BLOCKSIZE);
    UNSAFE_equal(ivtmp,iv);
    saferEncryptBlock(ivtmp,key.sfkey);
    UNSAFE_xor(ivtmp,pbuffer,ivnext,BLOCKSIZE);
    for(j=0;j<BLOCKSIZE;j++)pbuffer[j]^=qcypher(ivtmp[j]);
    blowfishDecrypt(&(key.bfkey),pbuffer);
    UNSAFE_xor(pbuffer,iv,pbuffer,BLOCKSIZE);
    ideaCipher(pbuffer,pbuffer,key.dk);
    UNSAFE_equal(iv,ivnext);
    bytes-=count;
    pbuffer+=BLOCKSIZE;
   }
   pbuffer=ppbuffer;
   if(write(target,pbuffer,bytesread)==-1)
                  {UNSAFE_destroykey(&key);errmsg("cant write target file",31);}
   display_percent(i);
  }
  memset(pbuffer,0,_uS_);
  free(pbuffer);
  burn(ivnext);
  burn(ivtmp);
 }
 return(error);
}

/*******************************************************************************
* procedure : UNSAFE_savefilehash(), write into the structure UNSAFE_HEADER    *
*             the file hash and let the file pointer at the begin of the file  *
* in : the UNSAFE_HEADER and the file pointer                                  *
* out : if all its ok return FALSE on error and save the hashing, else TRUE is *
*       returned on error and the hashing register has trash                   *
*******************************************************************************/
boolean UNSAFE_savefilehash(UNSAFE_HEADER *header,word16 file)
{
 void *buffer;
 word16 bytesread;
 MD5_INFO md5Info;
 word32 i;
 boolean error=FALSE;

 statusbar_init();
 i=filelength(file);

 gotoxy(12,13);cprintf("saving hashing...                          ");

 if(lseek(file,0,SEEK_SET)==-1L)error=TRUE;
 else
  {
   md5Initial(&md5Info);
   if((buffer=malloc(_uS_))==NULL)error=TRUE;
   else
    {
     bytesread=read(file,buffer,_uS_);
     md5Update(&md5Info,buffer,bytesread);
     while(bytesread==_uS_)
      {
       bytesread=read(file,buffer,_uS_);
       md5Update(&md5Info,buffer,bytesread);
       display_percent(i);
      }
     md5Final(&md5Info);
     memcpy((*header).filehash,md5Info.digest,16); /* 16 is the hash size*/
     if(lseek(file,0,SEEK_SET)==-1L)error=TRUE;
     free(buffer);
    }
  }
 return(error);
}

/*******************************************************************************
* procedure : UNSAFE_checkfilehash() check the hash made with                  *
*             UNSAFE_savefilehash()                                            *
* in : the UNSAFE_HEADER and filename                                          *
* out : if hashings mismatch return FALSE, else TRUE                           *
*******************************************************************************/
boolean UNSAFE_checkfilehash(UNSAFE_HEADER *header,byte *filename)
{
 void *buffer;
 word16 bytesread;
 MD5_INFO md5Info;
 boolean error=FALSE;
 int file;
 word32 i;

 statusbar_init();
 gotoxy(12,13);cprintf("checking hash...                          ");

 if((file=open(filename,O_RDONLY+O_BINARY))==-1)error=TRUE;
 else
  {
   i=filelength(file);
   md5Initial(&md5Info);
   if((buffer=malloc(_uS_))==NULL)error=TRUE;
   else
    {
     bytesread=read(file,buffer,_uS_);
     md5Update(&md5Info,buffer,bytesread);
     while(bytesread==_uS_)
      {
       bytesread=read(file,buffer,_uS_);
       md5Update(&md5Info,buffer,bytesread);
       display_percent(i);
      }
     md5Final(&md5Info);
     if(memcmp((*header).filehash,md5Info.digest,16)!=0)error=TRUE;
     free(buffer);
    }
   close(file);
  }
 return(error);
}

/*******************************************************************************
* procedure : UNSAFE_analizewipe(), analize the wipe parameters                *
* in : string with all arguments, wipe set var and wipe passes set var         *
* out : process of the arguments and return the sets if is available           *
*******************************************************************************/
boolean UNSAFE_analizewipe(byte *auxstr,byte *wipe,word16 *wipepasses)
{
 byte wfilename[MAXSIZE],auxpasses[MAXSIZE];
 word16 currentwipepasses=0;
 boolean error=FALSE;
 size_t ii=0,j=0;

 while((ii<=strlen(auxstr))&&(auxstr[ii]!=','))
  {
   wfilename[ii]=auxstr[ii];
   ii++;
  }
 wfilename[ii]=0;
 if((ii-1)==strlen(auxstr))error=TRUE;
 else
  {
   ii++;
   while(ii<=strlen(auxstr))
    {
     auxpasses[j]=auxstr[ii];
     ii++;
     j++;
    }
   if((currentwipepasses=atoi(auxpasses))==0)error=TRUE;
  }
 if(!error)
  {
   if(wfilename[0]=='\0')
    {
     *wipe=TRUE;
     *wipepasses=currentwipepasses;
    }
   else if(UNSAFE_wipe(wfilename,currentwipepasses))
                          {UNSAFE_destroykey(&key);errmsg("file not found",32);}
  }
 return(error);
}

/*******************************************************************************
* procedure : UNSAFE_parm2value, extract de value of a parameter like -pVALUE, *
*             when -p indicates that is a parameter and VALUE the value to     *
*             extract this function destroy in realtime the parameter          *
* in : 's' when you save the value, t is the parameter                         *
* out : return in 's' de value of one parameter                                *
* note : this procedure erase the VALUE part too                               *
*******************************************************************************/
void UNSAFE_parm2value(byte *s,byte *t)
{
 t++;t++;
 while(*t!=0)
  {
   *s=*t;
   *t=0; /* erase */
   t++;
   s++;
  }
 *s=0;
}

/*******************************************************************************
* procedure : UNSAFE_destroyparm, destroy the 'rest' of the parameter, when it *
*             pass in parm2value() - the '-p' string only...                   *
* in : string to destroy                                                       *
* out : string destroyed                                                       *
*******************************************************************************/
void UNSAFE_destroyparm(byte *s)
{while(*s!=0){*s=0;s++;}}

/*******************************************************************************
* procedure : UNSAFE_keygen, create keyfile                                    *
* in : key-filename, number of kbytes                                          *
* out : the key-filename with new kbytes of trash to use as a KEY              *
*******************************************************************************/
void UNSAFE_keygen(byte *filename,word32 kbytes)
{
 #define SIZEKEYGEN 1024   /* must be multiple of 8 */
 word16 k;

 word32 i,j;
 int keyfile;
 byte buffer[SIZEKEYGEN];

 randomize();
 if((keyfile=open(filename,O_CREAT+O_WRONLY+O_BINARY))==-1)
                       {UNSAFE_destroykey(&key);errmsg("cant make keyfile",33);}
 i=kbytes*1024L;
 statusbar_init();

 for(j=0;j<kbytes;j++)
 {
  for(k=0;k<SIZEKEYGEN;k++)
  {
   buffer[k]^=random(256);
   /*
    ideas for next versions
    -----------------------
     ...buffer hashing
     buffer[k]^=own_random();
     ...encrypt buffer using blowfish, using key=hash(password)
   */
  }
  if(write(keyfile,buffer,SIZEKEYGEN)==-1)
                   {UNSAFE_destroykey(&key);errmsg("cant write on keyfile",34);}
  display_percent(i);
 }
 close(keyfile);
}

/*******************************************************************************
* procedure : UNSAFE_wipe(),destroy a file (overwriting with trash), renaming, *
*             clear attributes, and before erase it.                           *
* in : filename, number of passes (if its zero, only erase)                    *
* out : return TRUE of FALSE, if this operation will be done                   *
*******************************************************************************/
word16 UNSAFE_wipe(byte *s,word16 passes)
{
 #define FILENAMEOVERWRITES 10
 int fp;
 word16 currentpasses,j,k,c,error=0;
 byte target[13]="unsafetr.ash\0";
 byte source[13]="unsafetr.ash\0";
 byte buffer[1024];
 byte x,y;
 word32 i;

 randomize();
 strcpy(source,s);
 _chmod(source,1,0); /* remove the file attributes */
 if((fp=open(source,O_RDWR+O_BINARY))==-1)UNSAFE_wipeerror("open",2);
 i=filelength(fp)*passes;
 close(fp);
 statusbar_init();
 if(passes>0)
 {
  gotoxy(12,13);cprintf("wiping file %s with %d passes                          ",source,passes);
 }

 if(!access(source,0))
 {
  if(passes!=0)
   {
    for(currentpasses=0;currentpasses<passes;currentpasses++)
    {
     for(j=0;j<FILENAMEOVERWRITES;j++);
     {
      do{/*make random filename*/
         for(k=0;k<strlen(target);k++)
         {
          if(target[k]!='.') /*this must be optimized*/
          {
           do c=random(256);while(!((c>='0'&&c<='9')||c>='A'&&c<='Z'));
           target[k]=c;
          }
         }
        }while(!access(target,0));
        if(rename(source,target)==-1)UNSAFE_wipeerror("rename",1);
        strcpy(source,target);
     }
     if((fp=open(source,O_RDWR+O_BINARY))==-1)UNSAFE_wipeerror("open",2);
     do
      {
       /* make random trashfile */
       for(j=0;j<sizeof(buffer);j++)
       UNSAFE_xor(&buffer[j],(byte *)random(256),&buffer[j],1);
       /*
        in next version it must be more strong
	using better random function
       */
       if(write(fp,buffer,sizeof(buffer))==-1)UNSAFE_wipeerror("write",3);
       display_percent(i);
      }
     while(!eof(fp));
     close(fp);
    }
    unlink(source);
   }
  else unlink(source);
 }
 else error=1;
 return(error);
}

/*******************************************************************************
* procedure : UNSAFE_wipeerror(), display an error on whitetrash()             *
* in : string, error numba                                                     *
* out : exit with errorlevel numba+100 and displaying string on screen         *
*******************************************************************************/
void UNSAFE_wipeerror(byte *cadena,word16 numba)
{
 byte message_str[MAXSIZE];

 strcpy(message_str,"cant wipe, ");
 strcat(message_str,cadena);
 strcat(message_str," impossible");
 UNSAFE_destroykey(&key);
 errmsg(message_str,numba+100);
}

/******************************************************************************
* procedure : UNSAFE_hlp, display the help screen of unsafe                   *
* in : the unsafe's full path to search the help file                         *
* out: shows the new funny help screen  ;)                                    *
******************************************************************************/
void UNSAFE_hlp(byte *fullpath)
{
 int (*p)();
 char *screen;
 char x,y;
 char ok_scr=1;
 char use_fullpath=0;

 if(access("unsafe.hlp",0)!=0)
 {
  fullpath[strlen(fullpath)-3]='h';
  fullpath[strlen(fullpath)-2]='l';
  fullpath[strlen(fullpath)-1]='p';
  if(access(fullpath,0)!=0)
                    {UNSAFE_destroykey(&key);errmsg("help file not found!",35);}
  else use_fullpath=1;
 }

 screen=malloc(4000);
 if(screen==NULL)
 {
  ok_scr=0;
  clrscr();
 }
 else
 {
  x=wherex();
  y=wherey();
  gettext(1,1,80,25,screen);
 }
 p=hlp_displayf;
 cursor(OFF);
 cutscr();
 textbackground(1);
 textcolor(15);
 cprintf(" unsafe on-line help  use the keys or mouse to move   ");
 if(!use_fullpath)readbin("unsafe.hlp",0L,HLPSIZE,1,2,80,25,p);
 else readbin(fullpath,0L,HLPSIZE,1,2,80,25,p);
 cursor(ON);
 if(ok_scr)
 {
  gotoxy(x,y);
  puttext(1,1,80,25,screen);
  free(screen);
 }
 else clrscr();
}

/*
last revision : 01 apr 2002
comments?     : jmind@gmx.net
updates       : http://www.unsafe.com.ar
*/